#include "core.h"
#include "process.h"
#include "master.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "dbmon.h"
#include "m68kcore.h"
#include "m68kdbmon.h"
#include "dsp32core.h"
#include "dsp32dbmon.h"
#include "mac32core.h"
#include "mac32dbmon.h"
#include "nrtx.h"
#include "m68knrtx.h"
#include "unix.h"
SRCFILE("rt.c")

#define	K	DB_KERNELID

RtConnections::RtConnections()
{
	Menu m, h, q;
	char conn[128], *c;
	int i;

	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED|ACCEPT_KBD);
	pad->name( "Rtpi" );
	pad->banner( "Rtpi: Copyright 1990-1993 AT&T" );
	h.last("help", (Action)&RtConnections::openhelp);
	m.last(h.index("help"));
	q.last("quit?", (Action)&RtConnections::exit);
	m.last(q.index("quit"));
	pad->menu(m);
	if( c = getenv("RTCONNECTIONS") ) {
		while(*c) {
			while (*c == ' ')
				c++;
			for (i = 0; *c && *c != ' '; i++, c++)
				conn[i] = *c;
			conn[i] = 0;
			if (i)
				kbd(conn);
		}
	}
	pad->makecurrent();
}

void RtConnections::exit() {  PadsQuit();  }

void RtConnections::openhelp()
{
	extern int helptopic(char*);
	helptopic("Introduction");
}

char *RtConnections::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Rtpi Window";
		case HELP_MENU:		return "Rtpi Menu Bar";
		case HELP_KEY:		return "Rtpi Keyboard";
		case HELP_LMENU:	return "Rtpi Line Menus";
		default:		return 0;
	}
}

char *RtConnections::kbd(char *s)
{
	RtNode *n = search(s);
	if (n)
		pad->insert((long)n, SELECTLINE, (PadRcv*)n, n->carte(),
			    n->name());
	else
		insert(new RtNode(this, sf("%s", s)));
	return 0;
}

RtNode *RtConnections::search(char *inetname)
{
	for (RtNode *n = child; n; n = n->sibling)
		if (eqstr(inetname, n->name()))
			break;
	return n;
}

void RtConnections::insert(RtNode *n)
{
	if (!child)
		child = n;
	else {
		n->sibling = child;
		child = n;
	}
	pad->insert((long)n, SELECTLINE, (PadRcv*)n, n->carte(), n->name());
}

RtNode::RtNode(RtConnections *c, char *s)
{
	parent = c;
	fd = -1;
	inetname = s;
}

char *RtNode::name()		{ return inetname; }

Index RtNode::carte()
{
	Menu m;
	m.last("open connection", (Action)&RtNode::open);
	return m.index();
}

char *RtNode::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Processors Window";
		case HELP_LMENU:	return "Processors Line Menus";
		default:		return 0;
	}
}

void RtNode::open()
{
	int pid;
	if (fd != -1)
		goto out;
	if (inetname[0] == '!') {
		int i;
		char string[256];
		char *argv[20], *cp;
		if (::strlen(&inetname[1]) >= 256)
			return;
		/* Break command line into arguments */
		::strcpy(string, &inetname[1]);
		for(i = 0, cp = string; *cp && i < 20; i++) {
			while (*cp == ' ' || *cp == '\t')
				cp++;
			if (!*cp)
				break;
			argv[i] = cp;
			do
				cp++;
			while(*cp && *cp != ' ' && *cp != '\t');
			if (*cp)
				*cp++ = 0;
		}
		if (i == 0 || i == 20)
			return;
		else
			argv[i] = 0;
		fd = ::dbpopen(argv);
	}	
	else
		fd = ::dbopen(inetname);	
	pid = ::dbpipeid;
	if (fd == -1 || ::dbrequest(fd, 0, K, DBR_GETNPROC, (int)&nboards,
	    0, sizeof(nboards)) == -1) {
		if (fd != -1) {
			::dbclose(fd);
			fd = -1;
		}
		parent->pad->insert(1, SELECTLINE, "Can't open %s", name());
		return;
	}
	nboards = (int)db_ntohl(nboards);
	if (nboards > 1) {
		pad = new Pad((PadRcv*) this );
		pad->options(TRUNCATE|SORTED);
		pad->name(name());
		pad->banner("%s:", name());
	}
	bmaster = new RtMaster *[nboards];
	register RtMaster *m;
	int i;
	DebugAttrib dba;
	for(i = 0; i < nboards; i++) {
		::dbrequest(fd, i, K, DBR_GETATTRIB,(int)&dba, 0, sizeof(dba));
		db_ntohsa(&dba.machine, 3);
		if (dba.os == DBOS_UNIX)
			m = new UnixMaster(fd, i, pid, this);
		else if (dba.os == DBOS_NRTX)
			m = new M68kNrtxMaster(fd, i, pid, this);
		else if (dba.machine == DBMT_32100)
			m = new Mac32DbmonMaster(fd, i, pid, this);
		else if (dba.machine == DBMT_DSP32 ||
			 dba.machine == DBMT_DSP32C)
			m = new Dsp32DbmonMaster(fd, i, pid, this);
		else
			m = new M68kDbmonMaster(fd, i, pid, this);
		bmaster[i] = m;
		if (pad)
			pad->insert((long)m, DONT_CUT, (PadRcv*)m, m->carte(),
				m->name());
	}
out:
	if (pad)
		pad->makecurrent();
	else
		bmaster[0]->open();
}

RtMaster::RtMaster(int f, int b, int p, RtNode *n)
{
	fd = f;
	boardid = b;
	pipeid = p;
	parent = n;
	char s[128];
	::dbrequest(f, b, K, DBR_GETBNAME, (int)s, 0, sizeof(s));
	bname = sf("%s", s);
}

Index RtMaster::carte()
{
	Menu m;
	m.last("open board", (Action)&RtMaster::open);
	return m.index();
}

void RtMaster::open()		{}
char *RtMaster::name()		{ return bname; }
